function [ppl] = Evaluate_obj(net, total_id, keep_id, para)
%
%%usage: [ppl] = Evaluate_obj(net, total_id, keep_id,para)
ppl = 0;
totalSample = size(keep_id,1);
batchSize  = 5000;
nClass= para.NNsize(length(para.NNsize));
SHIFT_VECTOR = (0:batchSize-1) * nClass;
SHIFT_VECTOR = SHIFT_VECTOR';
nBatches = floor( totalSample / batchSize);
Nsamples = nBatches * batchSize;
for batch = 1 : nBatches
    x=[];
    for j = 0 : para.n_words-1
        id = total_id(keep_id(1+(batch-1)* batchSize : batch*batchSize)+j);
        x =  [x net.codeBook(id,:)];
    end
    t = total_id(keep_id(1+(batch-1)* batchSize : batch*batchSize)+para.n_words);
    ppl = ppl + gather(Calculate_ppl(x, t, net, para, SHIFT_VECTOR));
end
if(totalSample> Nsamples)
    x = [];
    SHIFT_VECTOR = (0: totalSample-Nsamples-1) * nClass;
    SHIFT_VECTOR = SHIFT_VECTOR';
    for j = 0 : para.n_words-1
        id = total_id(keep_id(Nsamples+1:totalSample)+j);
        x =  [x net.codeBook(id,:)];
    end
    t = total_id(keep_id(Nsamples+1:totalSample)+para.n_words);
    ppl = ppl + gather(Calculate_ppl(x, t, net, para, SHIFT_VECTOR));
end
ppl = exp(-ppl/totalSample);