/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.TwoDimensionalMap;
import java.io.Serializable;
import java.util.Iterator;

public class TwoDimensionalSet<K1, K2>
implements Serializable,
Iterable<Pair<K1, K2>> {
    private static final long serialVersionUID = 2L;
    private final TwoDimensionalMap<K1, K2, Boolean> backingMap;

    public TwoDimensionalSet() {
        this(new TwoDimensionalMap());
    }

    public TwoDimensionalSet(TwoDimensionalMap<K1, K2, Boolean> backingMap) {
        this.backingMap = backingMap;
    }

    public static <K1, K2> TwoDimensionalSet<K1, K2> treeSet() {
        return new TwoDimensionalSet(TwoDimensionalMap.treeMap());
    }

    public static <K1, K2> TwoDimensionalSet<K1, K2> hashSet() {
        return new TwoDimensionalSet(TwoDimensionalMap.hashMap());
    }

    public boolean add(K1 k1, K2 k2) {
        return this.backingMap.put(k1, k2, true) != null;
    }

    public boolean addAll(TwoDimensionalSet<? extends K1, ? extends K2> set) {
        boolean result = false;
        for (Pair<K1, K2> pair : set) {
            if (!this.add(pair.first, pair.second)) continue;
            result = true;
        }
        return result;
    }

    public boolean addAllKeys(TwoDimensionalMap<? extends K1, ? extends K2, ?> map) {
        boolean result = false;
        for (TwoDimensionalMap.Entry<K1, K2, ?> entry : map) {
            if (!this.add(entry.getFirstKey(), entry.getSecondKey())) continue;
            result = true;
        }
        return result;
    }

    public void clear() {
        this.backingMap.clear();
    }

    public boolean contains(K1 k1, K2 k2) {
        return this.backingMap.contains(k1, k2);
    }

    public boolean containsAll(TwoDimensionalSet<? extends K1, ? extends K2> set) {
        for (Pair<K1, K2> pair : set) {
            if (this.contains(pair.first, pair.second)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TwoDimensionalSet)) {
            return false;
        }
        TwoDimensionalSet other = (TwoDimensionalSet)o;
        return this.backingMap.equals(other.backingMap);
    }

    public int hashCode() {
        return this.backingMap.hashCode();
    }

    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    public boolean remove(K1 k1, K2 k2) {
        return this.backingMap.remove(k1, k2);
    }

    public boolean removeAll(TwoDimensionalSet<? extends K1, ? extends K2> set) {
        boolean removed = false;
        for (Pair<K1, K2> pair : set) {
            if (!this.remove(pair.first, pair.second)) continue;
            removed = true;
        }
        return removed;
    }

    public int size() {
        return this.backingMap.size();
    }

    @Override
    public Iterator<Pair<K1, K2>> iterator() {
        return new TwoDimensionalSetIterator(this);
    }

    static class TwoDimensionalSetIterator<K1, K2>
    implements Iterator<Pair<K1, K2>> {
        Iterator<TwoDimensionalMap.Entry<K1, K2, Boolean>> backingIterator;

        TwoDimensionalSetIterator(TwoDimensionalSet<K1, K2> set) {
            this.backingIterator = ((TwoDimensionalSet)set).backingMap.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.backingIterator.hasNext();
        }

        @Override
        public Pair<K1, K2> next() {
            TwoDimensionalMap.Entry<K1, K2, Boolean> entry = this.backingIterator.next();
            return Pair.makePair(entry.getFirstKey(), entry.getSecondKey());
        }

        @Override
        public void remove() {
            this.backingIterator.remove();
        }
    }
}

